#include <stdio.h>

long long T[200000]; 

void merge_sort(long long *a, int n) {
    for (int len = 1; len < n; len *= 2) {
        for (int l = 0; l < n; l += 2 * len) {
            int m = l + len;
            int r = l + 2 * len;
            if (m > n) m = n;
            if (r > n) r = n;

            int i = l, j = m, k = l;

            while (i < m && j < r) {
                if (a[i] <= a[j]) T[k++] = a[i++];
                else T[k++] = a[j++];
            }
            while (i < m) T[k++] = a[i++];
            while (j < r) T[k++] = a[j++];

            for (i = l; i < r; i++) a[i] = T[i];
        }
    }
}

long long count_pairs(long long *a, int n) {
    long long res = 0;
    int i = 0;
    while (i < n) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        long long k = j - i;
        res += k * (k - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int n;
    scanf("%d", &n);

    long long A[200000], B[200000];

    for (int i = 0; i < n; i++) {
        long long x, y;
        scanf("%lld %lld", &x, &y);
        A[i] = x + y;
        B[i] = x - y;
    }

    merge_sort(A, n);
    merge_sort(B, n);

    long long ans = count_pairs(A, n) + count_pairs(B, n);

    printf("%lld\n", ans * 2);

    return 0;
}